$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tutorialCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui adicionamos o código para o SPED.',
                position: 'top'
            }
        },
        {
            element: '#tutorialDescricao',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Neste campo adicionamos a descrição do SPED.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o código SPED.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let sped = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADSPED', getCookie('usuario'), sped);
        window.location.href = `${BASE_URI}/sped`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido.",
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (sped != '' && sped != 'create') {

        if (await liberarRegistro('CADSPED', sped) == false) {
            window.location.href = '../sped';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabsped", 
                    "camposSelect":["codigo", "descricao"], 
                    "where": ["codigo = '${sped}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').attr('readonly', true);

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('#txtCodigo').change(async function () {
        try {
            $.LoadingOverlay('show');

            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"tabsped", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$('#txtCodigo').val()}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (jsonStr.RESULT[0].length > 0) {
                    msgAlerta('Código SPED já cadastrado.');
                    $('#txtCodigo').val('');
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                try {
                    $.LoadingOverlay("show");

                    sped = {};

                    sped.CODIGO = $('#txtCodigo').val();
                    sped.DESCRICAO = $('#txtDescricao').val();

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/cadsped?', `JSON=${encodeURIComponent(JSON.stringify(sped))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/sped`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});